/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpModelConstants;

public class DBGpBoolValue
extends DBGpValue {
    String[] allowedValues = new String[]{"false", "true"};

    public DBGpBoolValue(DBGpVariable owningVariable, Node property) {
        super(owningVariable, property);
        this.setModifiable(true);
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return "bool";
    }

    @Override
    void genValueString(String data) {
        this.setValueString(IDBGpModelConstants.INVALID_VAR_CONTENT);
        if (data != null) {
            try {
                int bool = Integer.parseInt(data);
                if (1 == bool) {
                    this.setValueString("true");
                } else if (bool == 0) {
                    this.setValueString("false");
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void setValue(String expression) throws DebugException {
        String data = expression.equals("true") ? "1" : (expression.equals("false") ? "0" : expression);
        this.genValueString(data);
    }

    @Override
    boolean verifyValue(String expression) throws DebugException {
        boolean allowed = false;
        int i = 0;
        while (i < this.allowedValues.length && !allowed) {
            if (expression.equals(this.allowedValues[i])) {
                allowed = true;
            }
            ++i;
        }
        return allowed;
    }
}

